<?php

defined('BASEPATH') or exit('No direct script access allowed');
header('Content-Type: text/html; charset=utf-8');

class Faceid extends App_Controller
{
    public function __construct()
    {
        parent::__construct();
        load_admin_language();
        $this->load->model('Authentication_model');
    }


    public function index()
    {
        $post = $this->input->post();
        $descriptor = json_decode($post['user_json'] ?? '', true);

        if (!$descriptor || !isset($post['user_id'])) {
            echo json_encode(['status' => 'failed', 'msg' => 'Invalid data']);
            return;
        }

        $this->load->model('facedata_model');
        $faceDataList = $this->facedata_model->get();
        
        

        foreach ($faceDataList as $data) {
            $dbDescriptor = json_decode(file_get_contents(FACELOGIN_JSONSAVE_FOLDER .'/'. $data['uniq_id'] . '.json'), true);
            $similarity = $this->euclideanDistance($descriptor, $dbDescriptor);
            if ($similarity < 0.6) {
                $this->process_login($data['user_id']);
                echo json_encode(['status' => 'success']);
                return;
            }
        }

        echo json_encode(['status' => 'failed']);
    }

    private function process_login($staff_id)
    {
        $this->session->set_userdata([
            'staff_user_id'   => $staff_id,
            'staff_logged_in' => true,
        ]);

        $this->load->model('announcements_model');
        $this->announcements_model->set_announcements_as_read_except_last_one($staff_id, true);

        $this->update_login_info($staff_id);
        $this->create_autologin($staff_id, true);

        hooks()->do_action('after_staff_login');
    }

    private function update_login_info($user_id)
    {
        $this->db->set('last_ip', $this->input->ip_address());
        $this->db->set('last_login', date('Y-m-d H:i:s'));
        $this->db->where('staffid', $user_id);
        $this->db->update(db_prefix() . 'staff');
    }

    private function create_autologin($user_id, $staff)
    {
        $this->load->helper('cookie');
        $key = substr(md5(uniqid(rand())), 0, 16);
        $this->user_autologin->delete($user_id, $key, $staff);

        if ($this->user_autologin->set($user_id, md5($key), $staff)) {
            set_cookie([
                'name'   => 'autologin',
                'value'  => serialize(['user_id' => $user_id, 'key' => $key]),
                'expire' => 60 * 60 * 24 * 31 * 2, // 2 months
            ]);
        }
    }
    private function euclideanDistance($d1, $d2) {
        $sum = 0;
        for ($i = 0; $i < count($d1); $i++) {
          $sum += pow($d1[$i] - $d2[$i], 2);
        }
        return sqrt($sum);
      }
}
